#extension GL_EXT_gpu_shader4 : enable

attribute vec4 position; 
attribute vec2 texcoord; 
uniform mat4 viewproj; 
uniform mat4 view;
uniform mat4 tview;
uniform mat4 proj;
uniform float pSize;
uniform float time;
varying vec2 otc; 
varying vec3 viewpos; 
varying vec3 opos; 
varying float zz;
varying float size; 

uniform float size_mix;
uniform float tracks[32];

void main()
{
	vec4 center = vec4(texcoord.xy-vec2(.5), 0.0, 1.0); 
	size =  pSize*75.0;//3.0*abs(4.*sin(position.y*.01+position.x*.01+time*3.51)+position.w*.3f+.7f);

	size =  75.0;//3.0*abs(4.*sin(position.y*.01+position.x*.01+time*3.51)+position.w*.3f+.7f);
	float size2 =  6.0*abs(2.*sin(position.y*.01+position.x*.01+time*3.51)+position.w*.3f+.7f);	
	size = tracks[29]*pSize*mix(size, size2, size_mix);

	vec4 bboard = size*(center.x*tview[0]+center.y*tview[1]);
	vec4 newPos = vec4(bboard.xyz+position.xyz, 1.0);
	gl_Position = proj*(vec4(0,0, .0,0)+view*newPos);

	viewpos = (view*vec4(position.xyz, 1.0)).xyz;
	otc = texcoord; 
	//sphere_size = 1.00;
	viewpos = view*newPos;
	otc = texcoord-.50;
	otc*= 3.5; 
	size *= .3;
}


//FRAGMENT
#version 420
//#extension GL_ARB_conservative_depth : enable
uniform mat4 proj;
in vec2 otc;
in vec3 viewpos;
in float size;
out vec4 outputColor;

//layout(early_fragment_tests) in;
layout (depth_less) out float gl_FragDepth;

void main() {

	float sphere_size =size;// 20.0;

	// compute correct sphere depth
	vec3 cameraPlanePos = vec3(otc*sphere_size, 0.0) + viewpos.xyz;
	vec3 rayDir = normalize(cameraPlanePos);
	float B= 2.0*dot(rayDir, -viewpos.xyz);
	float C= dot(viewpos.xyz, viewpos.xyz) - (sphere_size*sphere_size);
	float det = (B*B)-(4*C);
	
//	outputColor = vec4(.25);
//	return; 

	if(det < 00.00)
		discard;

	float sqrtDet = sqrt(det);
	float posT = (-B + sqrtDet)/2;
	float negT = (-B - sqrtDet)/2;
	float intersectT = min(posT, negT);
	vec3 cameraPos = rayDir * intersectT;
	vec3 cameraNormal = normalize(cameraPos - viewpos.xyz);


	//Set the depth based on the new cameraPos.
	vec4 clipPos = proj * vec4(cameraPos, 1.0);
	float ndcDepth = clipPos.z / clipPos.w;
	float clipDepth = ((gl_DepthRange.diff * ndcDepth) + gl_DepthRange.near + gl_DepthRange.far) / 2.0;
	gl_FragDepth = clipDepth;

	outputColor = vec4(.25);
	outputColor.a = 1.0;
	return; 

}
